#######################
#~Script Date By MiB!~#
#######################
import es
import cmdlib
import gamethread
import os
import urllib2
import installlib
import time
import psyco
psyco.full()

info = es.AddonInfo()
info["name"] = "Script Date"
info["basename"] = "scriptdate"
info["version"] = "0.3 BETA"
info["authors"] = "MiB"
info["url"] = "http://www.sddcommunity.com"
info["description"] = "Checks script versions."
pv = es.ServerVar("scriptdate_version")
pv.set(info["version"])
pv.makepublic()
addons = {}
basedir = str(es.ServerVar("eventscripts_gamedir")) + "\\"

def load():
    cmdlib.registerServerCommand("scriptdate_add_list",__cmd_add_list,"[Script Date] scriptdate_add_list <basename> <current version var> <auto update> <url to version files>")
    cmdlib.registerServerCommand("scriptdate_remove_list",__cmd_remove_list,"[Script Date] scriptdate_remove_list <basename>")
    cmdlib.registerServerCommand("scriptdate_check_list",__cmd_check_list,"[Script Date] scriptdate_check_list <basename> <return var>")

def unload():
    cmdlib.unregisterServerCommand("scriptdate_add_list")
    cmdlib.unregisterServerCommand("scriptdate_remove_list")
    cmdlib.unregisterServerCommand("scriptdate_check_list")

def es_map_start(ev):
    logWrite("+Log Opened+")
    logWrite("Checking all addon versions in addons dictionary....")
    try:
        if len(addons) > 0:
            for basename in addons:
                cversion = str(addons[basename]["version"])
                if cversion.isdigit(): cversion = int(cversion)
                update = __inter(basename)
                if update.getVersion() != cversion:
                    if addons[basename]["update"] == 1:
                        logWrite("Addon %s is not the current version, addon is being updated now...."%basename)
                        es.unload(basename)
                        update.Download()
                        logWrite("Addon %s is now fully updated...."%basename)
                        gamethread.delayed(0.1,es.load,(basename))
                    else: logWrite("Addon %s is not the current version, please download the current...."%basename)
                else: logWrite("Addon %s is current version...."%basename)
        logWrite("Addon versions checking complete....")
    except urllib2.URLError: logWrite("Could not finish, checking/updating canceled....")
    logWrite("+Log Closed+\n")

def add_list(basename,cversion,update,url):
    basename = str(basename)
    if not check_list(basename):
        if not url.startswith("http://"): url = "http://" + url
        if not url.endswith("/"): url = url + "/"
        addons[basename] = {}
        addons[basename]["version"] = es.ServerVar(cversion)
        addons[basename]["update"] = update
        addons[basename]["url"] = url
    else: es.dbgmsg(0,"[Script Date] Addon %s is already in the addons dictionary...."%basename)

def remove_list(basename):
    if check_list(basename): del addons[basename]
    else: es.dbgmsg(0,"[Script Date] Addon %s is not in the addons dictionary...."%basename)

def check_list(basename):
    if basename in addons: return True
    else: return False

def __cmd_add_list(args):
    if len(args) == 4: add_list(args[0],args[1],int(args[2]),args[3])
    else: es.dbgmsg(0,"[Script Date] Number of arguments needed is four....")

def __cmd_remove_list(args):
    if len(args) == 1: remove_list(args[0])
    else: es.dbgmsg(0,"[Script Date] Number of arguments needed is one....")

def __cmd_check_list(args):
    if len(args) == 2:
        if check_list(args[0]): value = 1
        else: value = 0
        sv = es.ServerVar(args[1]).set(value)
    else: es.dbgmsg(0,"[Script Date] Number of arguments needed is two....")

def logWrite(message):
    logpath = es.getAddonPath("scriptdate") + "/updatinglog.log"
    logfile = open(logpath,"a")
    message = time.strftime('%x %X') + " || " + message + "\n"
    logfile.write(message)
    logfile.close()

class __inter():
    def __init__(self,basename):
        self.basename = basename
        self.download = addons[self.basename]["url"] + self.basename + ".zip"
        self.vdownload = addons[self.basename]["url"] + self.basename + ".txt"
        self.ldownload = basedir + self.basename + ".zip"
        self.version = self.__getver()
    def __getver(self):
        uf = urllib2.urlopen(self.vdownload)
        uc = uf.readline()
        uf.close()
        if uc.isdigit(): uc = int(uc)
        return uc
    def __deleteFile(self,fp):
        os.chmod(fp,0777)
        os.remove(fp)
    def getVersion(self):
        return self.version
    def Download(self):
        logWrite("Started updating process for addon " + self.basename + "....")
        try:
            logWrite("Deleting addon " + self.basename + "'s old update zip...")
            self.__deleteFile(self.ldownload)
        except:
            logWrite("No old update zip was found for addon " + self.basename + "....")
        logWrite("Downloading addon " + self.basename + "'s update zip....")
        uf = urllib2.urlopen(self.download)
        fd = open(self.ldownload,"wb")
        fd.write(uf.read())
        fd.close()
        uf.close()
        logWrite("Starting the extracting process for addon " + self.basename + "'s update zip....")
        ex = installlib.getInstallerFromPath(self.basename,self.ldownload)
        if installlib.infomanager.hasInstallInfo(self.basename):
            logWrite("Deleting addon " + self.basename + "'s current files....")
            ex.uninstall()
        logWrite("Now extracting addon " + self.basename + "'s update files....")
        ex.install()
        try:
            gamethread.delayed(0.1,self.__deleteFile,(self.ldownload))
            logWrite("Deleted addon " + self.basename + "'s update zip....")
        except:
            logWrite("Couldn't delete addon " + self.basename + "'s update zip....")
        logWrite("Finished extracting process for addon " + self.basename + "'s update zip....")     
